package data.missions.arcade;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.SWPModPlugin;
import java.io.IOException;
import org.apache.log4j.Level;
import org.json.JSONException;
import org.json.JSONObject;

public class MissionDefinition implements MissionDefinitionPlugin {

    public static final String SETTINGS_FILE = "arcadeSettings.json";
    private String ship = "ssp_superhyperion_str";

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        try {
            reloadSettings();
        } catch (IOException | JSONException ex) {
            Global.getLogger(MissionDefinition.class).log(Level.ERROR, ex);
        }

        api.initFleet(FleetSide.PLAYER, "", FleetGoal.ATTACK, false, 25);
        api.initFleet(FleetSide.ENEMY, "SS", FleetGoal.ATTACK, true, 10);

        api.setFleetTagline(FleetSide.PLAYER, "Player");
        api.setFleetTagline(FleetSide.ENEMY, "Bad Guys");

        if (!SWPModPlugin.hasDynaSector) {
            api.addBriefingItem("DYNASECTOR REQUIRED");
            api.addBriefingItem("Download DynaSector to play this mission!");
            return;
        }

        api.addBriefingItem("Killing enemies makes you more powerful");
        api.addBriefingItem("Your foe grows stronger over time");
        api.addBriefingItem("Chain combos together for a score and CR multiplier");
        api.addBriefingItem("Ammo regenerates when you kill enemies");

        api.addToFleet(FleetSide.PLAYER, ship, FleetMemberType.SHIP, "MM Randy Savage", true).getCaptain().setPersonality(
                "aggressive");

        api.addToFleet(FleetSide.ENEMY, "ox_Standard", FleetMemberType.SHIP, "Scape", false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "ox_Standard", FleetMemberType.SHIP, "Goat", false).getCaptain().setPersonality(
                "aggressive");

        float width = 6000f;
        float height = 6000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        api.addPlugin(new MissionPlugin());
        api.addPlugin(new UnrealAnnouncer());
    }

    public void reloadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);

        ship = settings.getString("playerShip");
    }
}
